import string
#import Image
from pylab import *
from matplotlib import rc
import sys,subprocess
from matplotlib.font_manager import FontProperties
import matplotlib.gridspec as gridspec
#from matplotlib.mlab import load
import matplotlib.cm as cm
from matplotlib import patches
import os
import numpy as np

from mpl_toolkits.axes_grid1.inset_locator import inset_axes


######################################################################################################################################################
#   Code for producing Figure 4 in the main text.
#   The following data is used in this figure:
#   -- theory4IQRaw_const.txt, raw step distribution from the constrained diffusion theory (\mu_c = 5 k_B T) for the 4IQ myosin mutant
#   -- theory6IQRaw_const.txt, raw step distribution from the constrained diffusion theory (\mu_c = 5 k_B T) for 6IQ wild-type myosin
#   -- theory8IQRaw_const.txt, raw step distribution from the constrained diffusion theory (\mu_c = 5 k_B T) for the 8IQ myosin mutant
#   -- theory8IQSmall_Raw_const.txt, raw step distribution from the constrained diffusion theory (\mu_c = 5 k_B T) for the 8IQ myosin mutant with
#                                       long steps (>18 actin subunits head separation) removed
#
#   -- sim4IQRaw_const.txt, raw step distribution from BD simulations (with constraint \mu_c = 5 k_B T) of the 4IQ myosin mutant
#   -- sim6IQRaw_const.txt, raw step distribution from BD simulations (with constraint \mu_c = 5 k_B T) of 6IQ wild-type myosin
#   -- sim8IQRaw_const.txt, raw step distribution from BD simulations (with constraint \mu_c = 5 k_B T) of the 8IQ myosin mutant
#
#   -- oke4IQRaw.txt, raw step distribution of the 4IQ myosin mutant measured experimentally by Oke et al. (2010)
#   -- oke6IQRaw.txt, raw step distribution of the 6IQ wild-type myosin measured experimentally by Oke et al. (2010)
#   -- oke8IQRaw.txt, raw step distribution of the 8IQ myosin mutant measured experimentally by Oke et al. (2010)
#
#   -- theory4I_const.txt, full convolved step distribution from the constrained diffusion theory (\mu_c = 5 k_B T) for the 4IQ myosin mutant
#   -- theory6IQ_const.txt, full convolved step distribution from the constrained diffusion theory (\mu_c = 5 k_B T) for 6IQ wild-type myosin
#   -- theory8IQ_const.txt, full convolved step distribution from the constrained diffusion theory (\mu_c = 5 k_B T) for the 8IQ myosin mutant
#   -- theory8IQSmall_const.txt, full convolved step distribution from the constrained diffusion theory (\mu_c = 5 k_B T) for the 8IQ myosin mutant
#                                     with long steps (>18 actin subunits head separation) removed
#
#   -- sim4IQ_const.txt, full convolved step distribution from BD simulations (with constraint \mu_c = 5 k_B T) of the 4IQ myosin mutant
#   -- sim6IQ_const.txt, full convolved step distribution from BD simulations (with constraint \mu_c = 5 k_B T) of 6IQ wild-type myosin
#   -- sim8IQ_const.txt, full convolved step distribution from BD simulations (with constraint \mu_c = 5 k_B T) of the 8IQ myosin mutant
#
#   -- oke4IQRaw.txt, convolved and binned version of the 4IQ myosin mutant step distribution measured experimentally by Oke et al. (2010)
#   -- oke6IQRaw.txt, convolved and binned version of the 6IQ wild-type myosin step distribution measured experimentally by Oke et al. (2010)
#   -- oke8IQRaw.txt, convolved and binned version of the 8IQ myosin mutant step distribution measured experimentally by Oke et al. (2010)
#
#   -- yild6IQ.txt, 6IQ wild-type myosin step distribution measured experimentally by Yildiz et al. (2003)
#
#   -- sak4IQ.txt, 4IQ myosin mutant step distribution measured experimentally by Sakamoto et al. (2005)
#   -- sak6IQ.txt, 6IQ wild-type myosin step distribution measured experimentally by Sakamoto et al. (2005)
#   -- sak8IQ.txt, 8IQ myosin mutant step distribution measured experimentally by Sakamoto et al. (2005)

######################################################################################################################################################



def Fig2new() :
        xoff=0.16
        yoff=0.2
        width=0.88-xoff
        height=0.91-yoff

        dashes=[3,2]
        labelx=-0.13

        ############################################

        fig_width_pt = 246.0
        inches_per_pt = 1.0/72.27
        golden_mean = (sqrt(5)-1.0)/2.0
        fig_width = fig_width_pt*inches_per_pt
        fig_height = fig_width_pt*inches_per_pt*golden_mean
        fig_size =  [4*fig_width,3.5*fig_height]
        params = {'backend': 'ps',
                  'axes.labelsize': 10,
                  #'text.fontsize': 10,
                  'xtick.labelsize': 8,
                  'ytick.labelsize': 8,
                  'text.usetex': False,
                  "font.family": "sans-serif",
                  "text.latex.preamble": r"\usepackage{cmbright}",
                  'figure.figsize': fig_size,
                  'figure.subplot.left': xoff,
                  'figure.subplot.bottom': yoff,
                  'figure.subplot.right': xoff+width,
                  'figure.subplot.top': yoff+height}

        rcParams.update(params)
        # rc('font',**{'family':'sans-serif','sans-serif':['Helvetica']})


        figure(1)

        gs = gridspec.GridSpec(3, 3, width_ratios=[1,1,1], height_ratios=[4,1,4])
        gs.update(hspace=0.1,wspace=0.15,top=0.89)

        gs2= gridspec.GridSpec(1, 3)
        gs2.update(hspace=0.0,wspace=0.15,top=0.43,bottom=0.14)

        labx=0.035
        laby=0.89

        ##########################################


        t4IQact, theory4IQRaw = np.transpose(np.loadtxt('theory_step_distributions/theory4IQRaw_const.txt'))
        t6IQact, theory6IQRaw = np.transpose(np.loadtxt('theory_step_distributions/theory6IQRaw_const.txt'))
        t8IQact, theory8IQRaw = np.transpose(np.loadtxt('theory_step_distributions/theory8IQRaw_const.txt'))
        t8IQactShort, theory8IQRawShort = np.transpose(np.loadtxt('theory_step_distributions/theory8IQSmall_Raw_const.txt'))
        t4IQact, theory4IQRaw = t4IQact[18::2], theory4IQRaw[18::2]
        t4IQact, theory4IQRaw = np.append(t4IQact, range(19,24,2)), np.append(theory4IQRaw, np.zeros(3))
        t6IQact, theory6IQRaw = t6IQact[25::2], theory6IQRaw[25::2]
        t8IQact, theory8IQRaw = np.concatenate((t8IQact[33:-13][::2],t8IQact[-13::2][:-1], t8IQact[-2:-1])),np.concatenate((theory8IQRaw[33:-13][::2],theory8IQRaw[-13::2][:-1], theory8IQRaw[-2:-1]))
        t8IQactShort, theory8IQRawShort = t8IQactShort[19::2], theory8IQRawShort[19::2]


        s4IQact, sim4IQRaw = np.transpose(np.loadtxt('BD_step_distributions/sim4IQRaw_const.txt'))
        s6IQact, sim6IQRaw = np.transpose(np.loadtxt('BD_step_distributions/sim6IQRaw_const.txt'))
        s8IQact, sim8IQRaw = np.transpose(np.loadtxt('BD_step_distributions/sim8IQRaw_const.txt'))
        
        oke4IQact, oke4IQRaw = np.transpose(np.loadtxt('experimental_step_distributions/oke4IQRaw.txt'))
        oke6IQact, oke6IQRaw = np.transpose(np.loadtxt('experimental_step_distributions/oke6IQRaw.txt'))
        oke8IQact, oke8IQRaw = np.transpose(np.loadtxt('experimental_step_distributions/oke8IQRaw.txt'))
        oke4IQact, oke4IQRaw = oke4IQact[::2], oke4IQRaw[::2]
        oke4IQact, oke4IQRaw = np.append(oke4IQact, range(19,24,2)), np.append(oke4IQRaw, np.zeros(3))
        oke6IQact, oke6IQRaw = oke6IQact[::2], oke6IQRaw[::2]
        oke8IQact, oke8IQRaw = oke8IQact[1::2], oke8IQRaw[1::2]
        


        t4IQlen, theory4IQ = np.transpose(np.loadtxt("theory_step_distributions/theory4IQ_const.txt"))
        t6IQlen, theory6IQ = np.transpose(np.loadtxt("theory_step_distributions/theory6IQ_const.txt"))
        t8IQlen, theory8IQ = np.transpose(np.loadtxt("theory_step_distributions/theory8IQ_const.txt"))
        t8IQlenShort, theory8IQShort = np.transpose(np.loadtxt("theory_step_distributions/theory8IQSmall_const.txt"))

        s4IQlen, sim4IQ = np.transpose(np.loadtxt('BD_step_distributions/sim4IQ_const.txt'))
        s6IQlen, sim6IQ = np.transpose(np.loadtxt('BD_step_distributions/sim6IQ_const.txt'))
        s8IQlen, sim8IQ = np.transpose(np.loadtxt('BD_step_distributions/sim8IQ_const.txt'))
        

        oke4IQlen, oke4IQ = np.transpose(np.loadtxt('experimental_step_distributions/oke4IQ.txt'))
        oke6IQlen, oke6IQ = np.transpose(np.loadtxt('experimental_step_distributions/oke6IQ.txt'))
        oke8IQlen, oke8IQ = np.transpose(np.loadtxt('experimental_step_distributions/oke8IQ.txt'))
        yild6IQlen, yild6IQ = np.transpose(np.loadtxt('experimental_step_distributions/yild6IQ.txt'))
        sak4IQlen, sak4IQ = np.transpose(np.loadtxt('experimental_step_distributions/sak4IQ.txt'))
        sak6IQlen, sak6IQ = np.transpose(np.loadtxt('experimental_step_distributions/sak6IQ.txt'))
        sak8IQlen, sak8IQ = np.transpose(np.loadtxt('experimental_step_distributions/sak8IQ.txt'))
        

        
        ###########################################
        ###########################

        msize=6
        mkWidth=1
        
        subplot(gs[0])

        w=1
        bar(t4IQact,theory4IQRaw,width=w,color=(0.75,0.75,1.0),lw=1)

        plot(oke4IQact, oke4IQRaw, 'r^', markerfacecolor='w', markersize=msize, markeredgewidth=mkWidth)
        plot(s4IQact, sim4IQRaw, 'k+', markerfacecolor='w', markersize=msize+2, markeredgewidth=mkWidth)
        
        setp(gca(),xlim=[0,36],ylim=[0,0.7],xticks=arange(1,39,4))
        ylabel(r'Probability')

        text(labx,laby,r'A: 4IQ',transform=gca().transAxes,fontsize=12)
        moo=gca()

        ###########################################
        ###########################

        subplot(gs[1])

        w=1
        bar(t6IQact,theory6IQRaw,width=w,color=(0.75,0.75,1.0),lw=1)

        print(t6IQact, theory6IQRaw)
        plot(oke6IQact, oke6IQRaw, 'r^', markerfacecolor='w', markersize=msize, markeredgewidth=mkWidth)
        plot(s6IQact, sim6IQRaw, 'k+', markerfacecolor='w', markersize=msize+2, markeredgewidth=mkWidth)
        
        setp(gca(),xlim=[0,36],ylim=[0,0.65],xticks=arange(1,39,4))
        #ylabel(r'Probability')
        figtext(0.21,0.915,r'Raw step distributions, $\mathcal{P}_{\rm dist}^n$:',fontsize=14,horizontalalignment='center',color='Purple')

        text(labx,laby,r'B: 6IQ',transform=gca().transAxes,fontsize=12)

        ###########################################
        ###########################

        subplot(gs[2])

        w=1
        ths=bar(t8IQactShort,theory8IQRawShort,width=w,color=(1.0,0.65,0.65),lw=1)
        th=bar(t8IQact,theory8IQRaw,width=w,color=(0.75,0.75,1.0),lw=1)

        print(t8IQact, theory8IQRaw)
        oke,=plot(oke8IQact, oke8IQRaw, 'r^', markerfacecolor='w', markersize=msize, markeredgewidth=mkWidth)
        bd,=plot(s8IQact, sim8IQRaw, 'k+', markerfacecolor='w', markersize=msize+2, markeredgewidth=mkWidth)
        
        setp(gca(),xlim=[0,36],ylim=[0,0.55],xticks=arange(1,39,4))
        #ylabel(r'Probability')

        text(labx,laby,r'C: 8IQ',transform=gca().transAxes,fontsize=12)

        moo.legend([th, ths, bd, oke], [r'Theory',r'Theory (w/ cutoff)',r'BD simulations',r'Oke $et \, \, al.$'], loc=(0.46,0.57),frameon=False, fontsize=10, handlelength=0.7)


        ###########################################
        ###########################

        ra=5.5
        dang=-2*pi/13.0
        DD=36.0

        ###########################################
        ###########################

        subplot(gs[3])

        axis('off')

        ar=12
        
        maxc=theory4IQRaw[5]

        for n in range(-6,-1) :
                ht=theory4IQRaw[n+6]/maxc
                col=(1.0-ht,1.0-ht,1.0)
                plot([DD+2*DD*(n)/13.0],[-ra+ra*cos(dang*n)],'ko',mfc=col,mec='k',ms=ar,mew=1)

        for n in range(-7,6) :
                plot([DD+2*DD*(n+0.5)/13.0],[-ra+ra*cos(dang*(n+0.5)+pi)],'ko',mfc='w',mec='k',ms=ar,mew=1)
                
        for n in range(-1,7) :
                if(n<=5) :
                        ht=theory4IQRaw[n+6]/maxc
                        col=(1.0-ht,1.0-ht,1.0)
                else:
                        col='w'
                plot([DD+2*DD*(n)/13.0],[-ra+ra*cos(dang*n)],'ko',mfc=col,mec='k',ms=ar,mew=1)

        off=13

        for n in range(-6+off,-1+off) :
                plot([DD+2*DD*(n)/13.0],[-ra+ra*cos(dang*n)],'ko',mfc='w',mec='k',ms=ar,mew=1)
        
        for n in range(-7+off,6+off) :
                plot([DD+2*DD*(n+0.5)/13.0],[-ra+ra*cos(dang*(n+0.5)+pi)],'ko',mfc='w',mec='k',ms=ar,mew=1)

        setp(gca(),xlim=[0,DD+2*DD*(11.5)/13.0],ylim=[-60*0.35*1.5,30*0.35*1.5],xticks=[],yticks=[])
        figtext(0.235,0.19+0.315,r'Actin subunit',fontsize=10)
        
        ###########################################
        ###########################

        subplot(gs[4])
        
        axis('off')

        ar=12
        
        maxc=theory6IQRaw[6]

        for n in range(-6,-1) :
                ht=theory6IQRaw[n+6]/maxc
                col=(1.0-ht,1.0-ht,1.0)
                plot([DD+2*DD*(n)/13.0],[-ra+ra*cos(dang*n)],'ko',mfc=col,mec='k',ms=ar,mew=1)

        for n in range(-7,6) :
                plot([DD+2*DD*(n+0.5)/13.0],[-ra+ra*cos(dang*(n+0.5)+pi)],'ko',mfc='w',mec='k',ms=ar,mew=1)

        for n in range(-1,7) :
                if(n<=5) :
                        ht=theory6IQRaw[n+6]/maxc
                        col=(1.0-ht,1.0-ht,1.0)
                else:
                        col='w'
                plot([DD+2*DD*(n)/13.0],[-ra+ra*cos(dang*n)],'ko',mfc=col,mec='k',ms=ar,mew=1)

        off=13

        for n in range(-6+off,-1+off) :
                plot([DD+2*DD*(n)/13.0],[-ra+ra*cos(dang*n)],'ko',mfc='w',mec='k',ms=ar,mew=1)
        
        for n in range(-7+off,6+off) :
                plot([DD+2*DD*(n+0.5)/13.0],[-ra+ra*cos(dang*(n+0.5)+pi)],'ko',mfc='w',mec='k',ms=ar,mew=1)

        setp(gca(),xlim=[0,DD+2*DD*(11.5)/13.0],ylim=[-60*0.35*1.5,30*0.35*1.5],xticks=[],yticks=[])
        figtext(0.49,0.19+0.315,r'Actin subunit',fontsize=10)

        ###########################################
        ###########################

        subplot(gs[5])
        
        axis('off')

        ar=12
        
        maxc=theory8IQRaw[7]

        for n in range(-6,-1) :
                ht=theory8IQRaw[n+6]/maxc
                col=(1.0-ht,1.0-ht,1.0)
                plot([DD+2*DD*(n)/13.0],[-ra+ra*cos(dang*n)],'ko',mfc=col,mec='k',ms=ar,mew=1)

        for n in range(-7,6) :
                if(n>=3) :
                        ht=theory8IQRaw[n+7]/maxc
                        col=(1.0-ht,1.0-ht,1.0)
                else:
                        col='w'
                plot([DD+2*DD*(n+0.5)/13.0],[-ra+ra*cos(dang*(n+0.5)+pi)],'ko',mfc=col,mec='k',ms=ar,mew=1)

        for n in range(-1,7) :
                if(n<=3) :
                        ht=theory8IQRaw[n+6]/maxc
                        col=(1.0-ht,1.0-ht,1.0)
                else:
                        col='w'
                plot([DD+2*DD*(n)/13.0],[-ra+ra*cos(dang*n)],'ko',mfc=col,mec='k',ms=ar,mew=1)

        off=13

        for n in range(-6+off,-1+off) :
                plot([DD+2*DD*(n)/13.0],[-ra+ra*cos(dang*n)],'ko',mfc='w',mec='k',ms=ar,mew=1)
        
        for n in range(-7+off,6+off) :
                if(n>=3 and n<10) :
                        ht=theory8IQRaw[n+7]/maxc
                        col=(1.0-ht,1.0-ht,1.0)
                else:
                        col='w'
                plot([DD+2*DD*(n+0.5)/13.0],[-ra+ra*cos(dang*(n+0.5)+pi)],'ko',mfc=col,mec='k',ms=ar,mew=1)

        setp(gca(),xlim=[0,DD+2*DD*(11.5)/13.0],ylim=[-60*0.35*1.5,30*0.35*1.5],xticks=[],yticks=[])
        figtext(0.745,0.19+0.315,r'Actin subunit',fontsize=10)

        ###########################
        ####################################
        ###########################

        msize=6
        mkWidth=1
        
        subplot(gs2[0])

        w=3
        bar(t4IQlen,theory4IQ,width=w,color=(0.75,0.75,1.0),lw=1)

        plot(oke4IQlen, oke4IQ, 'r^', markerfacecolor='w', markersize=msize, markeredgewidth=mkWidth)
        plot(sak4IQlen, sak4IQ, 'bs', markerfacecolor='w', markersize=msize-1, markeredgewidth=mkWidth)
        plot(s4IQlen, sim4IQ, 'k+', markerfacecolor='w', markersize=msize+2, markeredgewidth=mkWidth)
        
        setp(gca(),xlim=[15-3,180-3],ylim=[0,0.4],xticks=arange(18.0,180,18.0),yticks=arange(0,0.5,0.1))
        ylabel(r'Probability')
        xlabel(r'Step size [nm]')

        text(labx,laby,r'D: 4IQ',transform=gca().transAxes,fontsize=12)
        moo=gca()

        ###########################################
        ###########################

        subplot(gs2[1])

        w=3
        bar(t6IQlen,theory6IQ,width=w,color=(0.75,0.75,1.0),lw=1)

        print(t6IQlen, theory6IQ)
        plot(oke6IQlen, oke6IQ, 'r^', markerfacecolor='w', markersize=msize, markeredgewidth=mkWidth)
        
        sak,=plot(sak6IQlen, sak6IQ, 'bs', markerfacecolor='w', markersize=msize-1, markeredgewidth=mkWidth)
        yild,=plot(yild6IQlen, yild6IQ, 'co', markerfacecolor='w', markersize=msize, markeredgewidth=mkWidth)
        plot(s6IQlen, sim6IQ, 'k+', markerfacecolor='w', markersize=msize+2, markeredgewidth=mkWidth)
        
        setp(gca(),xlim=[15-3,180-3],ylim=[0,0.35],xticks=arange(18.0,180,18.0),yticks=[0,0.1,0.2,0.3,0.4])
        #ylabel(r'Probability')
        xlabel(r'Step size [nm]')
        
        figtext(0.215,0.46,r'Full step distributions, $\mathcal{P}_{\rm T}(z_n)$:',fontsize=14,horizontalalignment='center',color='Purple')

        text(labx,laby,r'E: 6IQ',transform=gca().transAxes,fontsize=12)

        ###########################################
        ###########################

        subplot(gs2[2])

        w=3
        #ths=bar(t8IQlenShort,theory8IQShort,width=w,color=(1.0,0.65,0.65),lw=1)
        th=bar(t8IQlen,theory8IQ,width=w,color=(0.75,0.75,1.0),lw=1)

        #oke,=plot(oke8IQlen, oke8IQ, 'r^', markerfacecolor='w', markersize=msize, markeredgewidth=mkWidth)

        plot(sak8IQlen, sak8IQ, 'bs', markerfacecolor='w', markersize=msize-1, markeredgewidth=mkWidth)
        bd,=plot(s8IQlen, sim8IQ, 'k+', markerfacecolor='w', markersize=msize+2, markeredgewidth=mkWidth)
        
        setp(gca(),xlim=[15-3,180-3],ylim=[0,0.21],xticks=arange(18.0,180,18.0),yticks=[0,0.1,0.2,0.3,0.4])
        #ylabel(r'Probability')
        xlabel(r'Step size [nm]')
        
        text(labx,laby,r'F: 8IQ',transform=gca().transAxes,fontsize=12)

        moo.legend([th, bd, oke,sak,yild], [r'Theory',r'BD simulations',r'Oke $et \, \, al.$',r'Sakamoto $et \, \, al.$',r'Yildiz $et \, \, al.$'], loc=(0.48,0.48),frameon=False, fontsize=10, handlelength=0.7)

        ###########################################
        ###########################


        
        fign='step_distributions'
        savefig(fign+'.pdf',bbox_inches='tight')

Fig2new()

